using System;
using System.Collections.Generic;
using System.IO;
using System.Security.Cryptography;
using System.Text.Json;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http; //requires Microsoft.AspNetCore.Mvc.NewtonsoftJson package
using Microsoft.AspNetCore.OData.Query;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.FileProviders;
using Microsoft.Extensions.Hosting;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test;

[TestClass]
public class Test1
{
    public static IConfiguration? Configuration { get; set; }
    static MockHostingEnvironment Env { get; set; } = new MockHostingEnvironment();

    //TestContext is required even though it isn't used
    //otherwise tests don't run; they silently fail
    [AssemblyInitialize()]
    public static void AssemblyInit(TestContext context)
    {
        ArgumentNullException.ThrowIfNull(context);

        Configuration = new ConfigurationBuilder().AddJsonFile("appsettings.json").Build();
        var connString = Configuration.GetConnectionString("Database") ?? throw new Exception("Connection string not found");
        //env.ContentRootPath = context.TestRunResultsDirectory;
        Env.ContentRootPath = new DirectoryInfo(Directory.GetCurrentDirectory())?.FullName ?? "";
    }

    [TestMethod]
    public void AuthSecretGenerator()
    {
        RandomNumberGenerator cryptoRandomDataGenerator = RandomNumberGenerator.Create();
        byte[] buffer = new byte[16];
        cryptoRandomDataGenerator.GetBytes(buffer);
        string uniq = Convert.ToHexString(buffer);
        Assert.IsTrue(uniq.Length > 0);
    }

    internal static ODataQueryOptions<T> GetOdataOptions<T>(string routeUrl)
    {
        string path = "../.vscode/settings.json";
        string settingsText = File.ReadAllText(path);
        var settings = JsonSerializer.Deserialize<Dictionary<string, object>>(settingsText);
        string? port = "";
        if (settings != null)
            port = settings["fast.module.name"].ToString();

        var baseOdataStr = "https://127.0.0.1:443" + port + @"/odata";
        var uri = new Uri($"{baseOdataStr}/{routeUrl}");
        var httpContext = new DefaultHttpContext();

        HttpRequest request = httpContext.Request;
        request.Method = "GET";
        request.Host = new HostString(uri.Host, uri.Port);
        request.Path = uri.LocalPath;
        request.QueryString = new QueryString(uri.Query);

        var edmModel = Fast.Web.Helper.GetCustomEdmModel();
        ODataQueryContext context = new(edmModel, typeof(T), new Microsoft.OData.UriParser.ODataPath());
        ODataQueryOptions<T> options = new(context, request);

        return options;
    }

    internal class MockHostingEnvironment : IHostEnvironment, IWebHostEnvironment
    {
        public string EnvironmentName { get; set; } = Environments.Production;

        public string ApplicationName { get; set; } = "";

        public string WebRootPath { get; set; } = "";

        public string ContentRootPath { get; set; } = "";

        public IFileProvider ContentRootFileProvider { get; set; } = new PhysicalFileProvider("/");
        public IFileProvider WebRootFileProvider { get; set; } = new PhysicalFileProvider("/");

        IFileProvider IHostEnvironment.ContentRootFileProvider { get => throw new NotImplementedException(); set => throw new NotImplementedException(); }
    }
}
