import { inject, Injectable } from "@angular/core";
import { OdataGridHelper } from "../_shared/utils/odata-grid-helper";
import { HttpClient } from "@angular/common/http";
import { State } from "@progress/kendo-data-query";
import { Observable } from "rxjs";
import { GridDataResult } from "@progress/kendo-angular-grid";

export interface UserItem {
  id: number;
  userName: string;
  displayName: string;
  isLockedOut: boolean;
  groupNames: string;
  email: string;
  legalName: string;
  title: string;
}

export interface GroupItem {
  id: number;
  name: string;
}

@Injectable({
  providedIn: 'root'
})
export class UserManagerService extends OdataGridHelper {
  readonly baseUrl = `${window.location.origin}/api/UserManager`;
  http = inject(HttpClient)

  getUserItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetUserItems`, state, null, false)
  }

  getGroupItems(): Observable<GroupItem[]> {
    const url = `${this.baseUrl}/GetGroupItems`;
    return this.http.get<GroupItem[]>(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetUserItems`, state, null, fileNameOriginal);
  }
}
