import { inject, Injectable } from "@angular/core";
import { OdataGridHelper } from "../_shared/utils/odata-grid-helper";
import { Observable } from "rxjs";
import { HttpClient } from "@angular/common/http";
import * as util from '../_shared/utils/util';

export interface RequiredData {
  hasModifyPermission: boolean;
  securityGroups: util.IdName[];
}

export interface Detail {
  id: number;
  displayName: string;
  legalName: string;
  title: string;
  email: string;
  userName: string;
  tempPass: string;
  isLockedOut: boolean;
  groupNames: string;
  groupIds: number[];
}

export interface ApplicationUser {
  isUsingTempPassword: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class UserWindowService extends OdataGridHelper {
  readonly baseUrl = `${window.location.origin}/api/UserDetail`;
  http = inject(HttpClient)

  getRequiredData(): Observable<RequiredData> {
    const url = (`${this.baseUrl}/GetRequiredData`)
    return this.http.get<RequiredData>(url);
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: util.SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  generatePassword(): Observable<string> {
    const url = `${this.baseUrl}/GeneratePassword`;
    return this.http.get(url, { responseType: 'text' });
  }
}
