import { inject, Injectable } from "@angular/core";
import { OdataGridHelper } from "../_shared/utils/odata-grid-helper";
import { HttpClient } from "@angular/common/http";
import { Observable } from "rxjs";
import * as util from '../_shared/utils/util';

export interface RequiredData {
  hasModifyPermission: boolean;
  securityActions: SecurityAction[];
}

export interface SecurityAction {
  id: number;
  name: string;
  isView: boolean;
}

export interface SecurityPermission {
  securityActionId: number;
  isAllowed: boolean;
  isViewAllowed: boolean;
  isModifyAllowed: boolean;
}

export interface Detail {
  id: number;
  name: string;
  securityGroupPermissions: SecurityPermission[];
}

@Injectable({
  providedIn: 'root'
})
export class GroupDetailService extends OdataGridHelper {
  readonly baseUrl = `${window.location.origin}/api/GroupDetail`;
  http = inject(HttpClient)

  getRequiredData(): Observable<RequiredData> {
    const url = (`${this.baseUrl}/GetRequiredData`)
    return this.http.get<RequiredData>(url);
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: util.SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }
}
