import { ChangeDetectionStrategy, Component, inject, OnInit, signal } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { KENDO_DIALOG } from '@progress/kendo-angular-dialog';
import { UserDetailComponent } from "../user-detail/user-detail.component";
import { GroupDetailComponent } from "../group-detail/group-detail.component";

// This primarily helps with testing child components in isolation
// The test component URL is https://127.0.0.1:{port}/#/Test/{tag} where {tag} is one of the strings below, without quotes
// To hide the theme picker add the topless query parameter with a value of 1: https://127.0.0.1:{port}/#/Test/{tag}?topless=1
// The tag determines which child component is rendered

@Component({
  template: `
    <div id="container" class="t-bg-color2 col-g hideOverflow">
      @if(!tag()) { <h1 class="t-text-color1">place a test component tag with a tag conditional here: E.G. <div>{{exampleComponentHtmlString}}</div></h1> }
      @if(tag() === 'user-detail') { <app-user-detail [userId]="53"></app-user-detail> } <!-- UserDetailComponent, using ID for Alex -->
      @if(tag() === 'group-detail') { <app-group-detail [groupId]="2"></app-group-detail> } <!-- GroupDetailComponent, using ID for Gas Accounting -->
    </div>
  `,
  styles: `
    app-test { background-color: gray; height: 100%; }
    app-test #container > * { display: flex; flex-grow: 1; flex-direction: column; height: 100%; }
  `,
  selector: 'app-test',
  changeDetection: ChangeDetectionStrategy.OnPush,
  standalone: true,
  imports: [KENDO_DIALOG, UserDetailComponent, GroupDetailComponent]
})
export class TestComponent implements OnInit {
  exampleComponentHtmlString = `
    @if (tag() === 'approval-docs') { <app-approval-docs [creditLimitId]="361"]></app-approval-docs> }
  `;
  route = inject(ActivatedRoute);
  tag = signal<string>(null);

  ngOnInit(): void {
    this.route.params.subscribe(params => {
      this.tag.set(params['tag']);
    });
  }
}
