import { Pipe, PipeTransform } from '@angular/core';
import dayjs from 'dayjs';

@Pipe({
  name: 'dateConvert'
})
export class DateConvertPipe implements PipeTransform {
  transform(maybeDate: dayjs.ConfigType): Date {
    let newDate: Date = null;
    if (maybeDate && dayjs(maybeDate).isValid)
      newDate = dayjs(maybeDate).toDate();
    return newDate;
  }
}
