import { ChangeDetectionStrategy, Component, computed, ElementRef, input, output } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ContextMenuSelectEvent, ContextMenuTargetContainerDirective, MenuModule } from '@progress/kendo-angular-menu';
import { FAST_KENDO_COMMON } from '../../app.config';

@Component({
  selector: 'fast-contextmenu',
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_KENDO_COMMON, CommonModule, MenuModule],
  providers: [{
    provide: NG_VALUE_ACCESSOR,
    multi: true,
    useExisting: FastContextMenuComponent
  }],
  template: `
    <kendo-contextmenu #mainContextMenu
      [target]="target()"
      [items]="items()"
      (select)="this.select.emit($event);"
      [class]="conditionalClasses()"
    >
      <ng-content></ng-content>
    </kendo-contextmenu>
  `,
})

export class FastContextMenuComponent<T extends object> {

  target = input<string | HTMLElement | ElementRef<unknown> | ContextMenuTargetContainerDirective | null>(null);
  items = input.required<T[]>();
  // eslint-disable-next-line @angular-eslint/no-output-native
  select = output<ContextMenuSelectEvent>();

  conditionalClasses = computed(() => {
    const classes = [] as string[];

    classes.push(...this.getLightBaseClasses());
    classes.push(...this.getDarkBaseClasses());
    classes.push(...this.getLightActiveClasses());
    classes.push(...this.getDarkActiveClasses());

    const conditionalClasses = this.getConditionalClassesFromArrays(classes);
    return conditionalClasses;
  });

  getConditionalClassesFromArrays(classArray: string[]): { [key: string]: boolean } {
    const classes: { [key: string]: boolean } = {};
    classArray.forEach(className => {
      classes[className] = true;
    });
    return classes;
  }

  getLightBaseClasses() {
    return [
      "[&_button]:text-base-black-1000",
      "[&_button]:bg-base-white-250",
      "[&_button]:hover:bg-base-white-750"];
  }

  getDarkBaseClasses() {
    return [
      "dark:[&_button]:text-base-white-500",
      "dark:[&_button]:bg-alt-gray-500",
      "dark:[&_button]:hover:bg-alt-blue-750"];
  }

  getLightActiveClasses() {
    return [
      "[&_button]:active:bg-base-white-1000"];
  }

  getDarkActiveClasses() {
    return [
      "dark:[&_button]:active:bg-alt-blue-250"];
  }
}
