using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("zone")]
[Index("PipelineId", Name = "ix_zone")]
public partial class Zone
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("display_index")]
    public int? DisplayIndex { get; set; }

    [Column("pipeline_id")]
    public int PipelineId { get; set; }

    [Column("fuel_percent")]
    public double? FuelPercent { get; set; }

    [InverseProperty("SourceZone")]
    public virtual ICollection<MeterProduct> MeterProducts { get; set; } = new List<MeterProduct>();

    [InverseProperty("Zone")]
    public virtual ICollection<PipeContractDeliveryZone> PipeContractDeliveryZones { get; set; } = new List<PipeContractDeliveryZone>();

    [InverseProperty("Zone")]
    public virtual ICollection<PipeContractReceiptZone> PipeContractReceiptZones { get; set; } = new List<PipeContractReceiptZone>();

    [ForeignKey("PipelineId")]
    [InverseProperty("Zones")]
    public virtual Pipeline Pipeline { get; set; } = null!;

    [InverseProperty("Zone")]
    public virtual ICollection<PipelineRateDiscountedFromTo> PipelineRateDiscountedFromTos { get; set; } = new List<PipelineRateDiscountedFromTo>();

    [InverseProperty("Zone")]
    public virtual ICollection<Point> Points { get; set; } = new List<Point>();
}
