using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("report")]
[Index("Name", Name = "uk_report", IsUnique = true)]
public partial class Report
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("data_source_ids", TypeName = "citext")]
    public string DataSourceIds { get; set; } = null!;

    [Column("template_file_name_original", TypeName = "citext")]
    public string TemplateFileNameOriginal { get; set; } = null!;

    [Column("template_file_name_on_disk", TypeName = "citext")]
    public string TemplateFileNameOnDisk { get; set; } = null!;

    [Column("security_group_ids", TypeName = "citext")]
    public string? SecurityGroupIds { get; set; }

    [Column("security_user_ids", TypeName = "citext")]
    public string? SecurityUserIds { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("save_as_pdf")]
    public bool SaveAsPdf { get; set; }

    [InverseProperty("Report")]
    public virtual ICollection<ReportFilter> ReportFilters { get; set; } = new List<ReportFilter>();
}
