using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("product_category")]
[Index("Name", Name = "uk_product_category", IsUnique = true)]
[Index("Name", Name = "uk_product_category_name", IsUnique = true)]
public partial class ProductCategory
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("description", TypeName = "citext")]
    public string Description { get; set; } = null!;

    [Column("prefix", TypeName = "citext")]
    public string Prefix { get; set; } = null!;

    [InverseProperty("ProductCategory")]
    public virtual ICollection<CreditLimitCounterparty> CreditLimitCounterparties { get; set; } = new List<CreditLimitCounterparty>();

    [InverseProperty("Category")]
    public virtual ICollection<Product> Products { get; set; } = new List<Product>();
}
