using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_contract")]
[Index("PipelineId", "ContractId", Name = "uk_pipeline_contract", IsUnique = true)]
public partial class PipelineContract
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("original_creation_time")]
    public DateTime? OriginalCreationTime { get; set; }

    [Column("original_creation_user_id")]
    public int? OriginalCreationUserId { get; set; }

    [Column("buy_sell")]
    public bool BuySell { get; set; }

    [Column("transaction_type_id")]
    public int? TransactionTypeId { get; set; }

    [Column("internal_entity_id")]
    public int? InternalEntityId { get; set; }

    [Column("counterparty_id")]
    public int? CounterpartyId { get; set; }

    [Column("contract_owner_id")]
    public int? ContractOwnerId { get; set; }

    [Column("pipeline_id")]
    public int PipelineId { get; set; }

    [Column("contract_id", TypeName = "citext")]
    public string ContractId { get; set; } = null!;

    [Column("rate_schedule_id")]
    public int? RateScheduleId { get; set; }

    [Column("is_capacity_release")]
    public bool IsCapacityRelease { get; set; }

    [Column("front_payment")]
    public double? FrontPayment { get; set; }

    [Column("start_date")]
    public DateOnly? StartDate { get; set; }

    [Column("end_date")]
    public DateOnly? EndDate { get; set; }

    [Column("display_uom_id")]
    public int? DisplayUomId { get; set; }

    [Column("is_all_receipt_zone")]
    public bool IsAllReceiptZone { get; set; }

    [Column("is_all_delivery_zone")]
    public bool IsAllDeliveryZone { get; set; }

    [Column("is_all_receipt_meter")]
    public bool IsAllReceiptMeter { get; set; }

    [Column("is_all_delivery_meter")]
    public bool IsAllDeliveryMeter { get; set; }

    [Column("receipt_zone_id_list", TypeName = "citext")]
    public string? ReceiptZoneIdList { get; set; }

    [Column("delivery_zone_id_list", TypeName = "citext")]
    public string? DeliveryZoneIdList { get; set; }

    [Column("receipt_meter_id_list", TypeName = "citext")]
    public string? ReceiptMeterIdList { get; set; }

    [Column("delivery_meter_id_list", TypeName = "citext")]
    public string? DeliveryMeterIdList { get; set; }

    [Column("max_ddq")]
    public double? MaxDdq { get; set; }

    [Column("aca_rate")]
    public double? AcaRate { get; set; }

    [Column("demand_charge")]
    public double? DemandCharge { get; set; }

    [Column("demand_charge_use_tariff")]
    public bool? DemandChargeUseTariff { get; set; }

    [Column("commodity_charge")]
    public double? CommodityCharge { get; set; }

    [Column("commodity_charge_use_tariff")]
    public bool? CommodityChargeUseTariff { get; set; }

    [Column("fuel_charge")]
    public double? FuelCharge { get; set; }

    [Column("fuel_charge_use_tariff")]
    public bool? FuelChargeUseTariff { get; set; }

    [Column("is_hypothetical")]
    public bool? IsHypothetical { get; set; }

    [Column("is_ptr_contract")]
    public bool IsPtrContract { get; set; }

    [Column("comments", TypeName = "citext")]
    public string? Comments { get; set; }

    [Column("internal_memo", TypeName = "citext")]
    public string? InternalMemo { get; set; }

    [Column("update_notes", TypeName = "citext")]
    public string? UpdateNotes { get; set; }

    [Column("last_modified_time")]
    public DateTime? LastModifiedTime { get; set; }

    [Column("last_modified_user_id")]
    public int? LastModifiedUserId { get; set; }

    [Column("num_of_updates")]
    public int? NumOfUpdates { get; set; }

    [Column("rate_unit_time_option")]
    public int? RateUnitTimeOption { get; set; }

    [Column("imbalance_nom_type_id")]
    public int? ImbalanceNomTypeId { get; set; }

    [Column("contract_file", TypeName = "citext")]
    public string? ContractFile { get; set; }

    [Column("signed_contract_file", TypeName = "citext")]
    public string? SignedContractFile { get; set; }

    [Column("log_notes", TypeName = "citext")]
    public string? LogNotes { get; set; }

    [Column("contract_type_id")]
    public int? ContractTypeId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [ForeignKey("ContractOwnerId")]
    [InverseProperty("PipelineContractContractOwners")]
    public virtual Counterparty? ContractOwner { get; set; }

    [ForeignKey("ContractTypeId")]
    [InverseProperty("PipelineContracts")]
    public virtual PipelineContractType? ContractType { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("PipelineContractCounterparties")]
    public virtual Counterparty? Counterparty { get; set; }

    [InverseProperty("ToPipeContract")]
    public virtual ICollection<CrudePathRoute> CrudePathRoutes { get; set; } = new List<CrudePathRoute>();

    [InverseProperty("SourcePipeContract")]
    public virtual ICollection<CrudePath> CrudePaths { get; set; } = new List<CrudePath>();

    [InverseProperty("PipelineContract")]
    public virtual ICollection<CrudeSupply> CrudeSupplyPipelineContracts { get; set; } = new List<CrudeSupply>();

    [InverseProperty("PtrPipelineContract")]
    public virtual ICollection<CrudeSupply> CrudeSupplyPtrPipelineContracts { get; set; } = new List<CrudeSupply>();

    [InverseProperty("ToPipeContract")]
    public virtual ICollection<GasPathRoute> GasPathRoutes { get; set; } = new List<GasPathRoute>();

    [InverseProperty("SourcePipeContract")]
    public virtual ICollection<GasPath> GasPaths { get; set; } = new List<GasPath>();

    [InverseProperty("PipelineContract")]
    public virtual ICollection<GasSupply> GasSupplyPipelineContracts { get; set; } = new List<GasSupply>();

    [InverseProperty("PtrPipelineContract")]
    public virtual ICollection<GasSupply> GasSupplyPtrPipelineContracts { get; set; } = new List<GasSupply>();

    [ForeignKey("ImbalanceNomTypeId")]
    [InverseProperty("PipelineContracts")]
    public virtual ImbalanceNomType? ImbalanceNomType { get; set; }

    [ForeignKey("InternalEntityId")]
    [InverseProperty("PipelineContractInternalEntities")]
    public virtual Counterparty? InternalEntity { get; set; }

    [ForeignKey("OriginalCreationUserId")]
    [InverseProperty("PipelineContracts")]
    public virtual AppUser? OriginalCreationUser { get; set; }

    [InverseProperty("PipeContract")]
    public virtual ICollection<PipeContractDeliveryMeter> PipeContractDeliveryMeters { get; set; } = new List<PipeContractDeliveryMeter>();

    [InverseProperty("PipeContract")]
    public virtual ICollection<PipeContractDeliveryZone> PipeContractDeliveryZones { get; set; } = new List<PipeContractDeliveryZone>();

    [InverseProperty("PipeContract")]
    public virtual ICollection<PipeContractDoc> PipeContractDocs { get; set; } = new List<PipeContractDoc>();

    [InverseProperty("PipeContract")]
    public virtual ICollection<PipeContractReceiptMeter> PipeContractReceiptMeters { get; set; } = new List<PipeContractReceiptMeter>();

    [InverseProperty("PipeContract")]
    public virtual ICollection<PipeContractReceiptZone> PipeContractReceiptZones { get; set; } = new List<PipeContractReceiptZone>();

    [ForeignKey("PipelineId")]
    [InverseProperty("PipelineContracts")]
    public virtual Pipeline Pipeline { get; set; } = null!;

    [InverseProperty("PipeContract")]
    public virtual ICollection<PipelineContractDefault> PipelineContractDefaults { get; set; } = new List<PipelineContractDefault>();

    [InverseProperty("DefaultPtrPipelineContract")]
    public virtual ICollection<Pipeline> Pipelines { get; set; } = new List<Pipeline>();

    [ForeignKey("ProductId")]
    [InverseProperty("PipelineContracts")]
    public virtual Product Product { get; set; } = null!;

    [ForeignKey("RateScheduleId")]
    [InverseProperty("PipelineContracts")]
    public virtual PipelineRateSchedule? RateSchedule { get; set; }

    [ForeignKey("TransactionTypeId")]
    [InverseProperty("PipelineContracts")]
    public virtual TransactionType? TransactionType { get; set; }
}
