using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipe_contract_delivery_zone")]
[Index("PipeContractId", "ZoneId", Name = "uk_pipe_contract_delivery_zone", IsUnique = true)]
public partial class PipeContractDeliveryZone
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipe_contract_id")]
    public int PipeContractId { get; set; }

    [Column("zone_id")]
    public int ZoneId { get; set; }

    [ForeignKey("PipeContractId")]
    [InverseProperty("PipeContractDeliveryZones")]
    public virtual PipelineContract PipeContract { get; set; } = null!;

    [ForeignKey("ZoneId")]
    [InverseProperty("PipeContractDeliveryZones")]
    public virtual Zone Zone { get; set; } = null!;
}
