using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("market_price")]
[Index("PriceDate", "MarketTypeId", "PublishDate", "IndexId", "ContractMonth", "Id", "Price", Name = "idx_26739_ix_market_price")]
[Index("IndexId", "PriceDate", "ContractMonth", "MarketTypeId", Name = "idx_26739_uk_market_price", IsUnique = true)]
[Index("MarketTypeId", Name = "ix_market_price")]
[Index("IndexId", Name = "ix_market_price_1")]
[Index("ContractMonth", Name = "ix_market_price_2")]
[Index("PriceDate", Name = "ix_market_price_5")]
[Index("PublishDate", Name = "ix_market_price_6")]
[Index("MarketTypeId", "PriceDate", "DataInputTime", "IndexId", Name = "ix_market_price_7")]
public partial class MarketPrice
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("price_date")]
    public DateOnly PriceDate { get; set; }

    [Column("contract_month")]
    public DateOnly ContractMonth { get; set; }

    [Column("publish_date")]
    public DateOnly? PublishDate { get; set; }

    [Column("market_type_id")]
    public int MarketTypeId { get; set; }

    [Column("index_id")]
    public int? IndexId { get; set; }

    [Column("price")]
    public double Price { get; set; }

    [Column("data_input_time")]
    public DateTime? DataInputTime { get; set; }

    [Column("data_inputer_id")]
    public int? DataInputerId { get; set; }

    [ForeignKey("DataInputerId")]
    [InverseProperty("MarketPrices")]
    public virtual AppUser? DataInputer { get; set; }

    [ForeignKey("IndexId")]
    [InverseProperty("MarketPrices")]
    public virtual MarketIndex? Index { get; set; }

    [ForeignKey("MarketTypeId")]
    [InverseProperty("MarketPrices")]
    public virtual MarketType MarketType { get; set; } = null!;
}
