using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("market_index_alias_type")]
[Index("Name", Name = "uk_market_index_alias_type", IsUnique = true)]
public partial class MarketIndexAliasType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("IndexAliasType")]
    public virtual ICollection<MarketIndexAlias> MarketIndexAliases { get; set; } = new List<MarketIndexAlias>();
}
