using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("gas_supply")]
[Index("Date", "DealId", "PointId", "MeterId", "ActNumber", "Comment", "SourceNotes", "PipelineContractId", "Ptr", "PtrDeliveryMeterId", "PtrPipelineContractId", "CreatedTime", "SavedTime", Name = "idx_26597_ix_gas_supply_date_deal_point_meter")]
[Index("MeterId", Name = "ix_gas_supply_1")]
[Index("Date", Name = "ix_gas_supply_2")]
[Index("TransferDealId", Name = "ix_gas_supply_3")]
[Index("DealId", Name = "ix_gas_supply_4")]
[Index("PipelineContractId", Name = "ix_gas_supply_5")]
[Index("DealId", "Date", "TransferDealId", "PointId", "MeterId", "PipelineContractId", Name = "uk_gas_supply", IsUnique = true)]
public partial class GasSupply
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("deal_id")]
    public int? DealId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("meter_id")]
    public int? MeterId { get; set; }

    [Column("transfer_deal_id")]
    public int? TransferDealId { get; set; }

    [Column("rank")]
    public int Rank { get; set; }

    [Column("pipeline_cycle_id")]
    public int PipelineCycleId { get; set; }

    [Column("pipeline_contract_id")]
    public int? PipelineContractId { get; set; }

    [Column("duns_id")]
    public int? DunsId { get; set; }

    [Column("date")]
    public DateOnly Date { get; set; }

    [Column("act_number", TypeName = "citext")]
    public string? ActNumber { get; set; }

    [Column("ptr_delivery_meter_id")]
    public int? PtrDeliveryMeterId { get; set; }

    [Column("ptr_pipeline_contract_id")]
    public int? PtrPipelineContractId { get; set; }

    [Column("ptr")]
    public double? Ptr { get; set; }

    [Column("comment", TypeName = "citext")]
    public string? Comment { get; set; }

    [Column("source_notes", TypeName = "citext")]
    public string? SourceNotes { get; set; }

    [Column("saved_by")]
    public int SavedBy { get; set; }

    [Column("created_by")]
    public int CreatedBy { get; set; }

    [Column("saved_time")]
    public DateTime SavedTime { get; set; }

    [Column("created_time")]
    public DateTime CreatedTime { get; set; }

    [ForeignKey("CreatedBy")]
    [InverseProperty("GasSupplyCreatedByNavigations")]
    public virtual AppUser CreatedByNavigation { get; set; } = null!;

    [ForeignKey("DealId")]
    [InverseProperty("GasSupplies")]
    public virtual Deal? Deal { get; set; }

    [ForeignKey("DunsId")]
    [InverseProperty("GasSupplies")]
    public virtual DunsNumber? Duns { get; set; }

    [InverseProperty("SupplyNom")]
    public virtual ICollection<GasActual> GasActuals { get; set; } = new List<GasActual>();

    [InverseProperty("SupplyNom")]
    public virtual ICollection<GasMarketSupply> GasMarketSupplies { get; set; } = new List<GasMarketSupply>();

    [ForeignKey("MeterId")]
    [InverseProperty("GasSupplyMeters")]
    public virtual Meter? Meter { get; set; }

    [ForeignKey("PipelineContractId")]
    [InverseProperty("GasSupplyPipelineContracts")]
    public virtual PipelineContract? PipelineContract { get; set; }

    [ForeignKey("PointId")]
    [InverseProperty("GasSupplies")]
    public virtual Point? Point { get; set; }

    [ForeignKey("PtrDeliveryMeterId")]
    [InverseProperty("GasSupplyPtrDeliveryMeters")]
    public virtual Meter? PtrDeliveryMeter { get; set; }

    [ForeignKey("PtrPipelineContractId")]
    [InverseProperty("GasSupplyPtrPipelineContracts")]
    public virtual PipelineContract? PtrPipelineContract { get; set; }

    [ForeignKey("SavedBy")]
    [InverseProperty("GasSupplySavedByNavigations")]
    public virtual AppUser SavedByNavigation { get; set; } = null!;

    [ForeignKey("TransferDealId")]
    [InverseProperty("GasSupplies")]
    public virtual TransferDeal? TransferDeal { get; set; }
}
