using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("gas_market_supply")]
[Index("Date", "MarketNomId", "SupplyNomId", "Volume", Name = "idx_26574_ix_gas_market_supply_date")]
[Index("Date", Name = "ix_gas_market_supply")]
[Index("IsActual", Name = "ix_gas_market_supply_2")]
[Index("MarketNomId", Name = "ix_gas_market_supply_3")]
[Index("SupplyNomId", Name = "ix_gas_market_supply_4")]
[Index("Date", "SupplyNomId", "MarketNomId", "IsActual", Name = "uk_gas_market_supply", IsUnique = true)]
public partial class GasMarketSupply
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("date")]
    public DateOnly Date { get; set; }

    [Column("supply_nom_id")]
    public int SupplyNomId { get; set; }

    [Column("market_nom_id")]
    public int MarketNomId { get; set; }

    [Column("volume")]
    public int? Volume { get; set; }

    [Column("comment", TypeName = "citext")]
    public string? Comment { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("is_keep_whole")]
    public bool IsKeepWhole { get; set; }

    [Column("is_actual")]
    public bool IsActual { get; set; }

    [Column("actual_volume")]
    public int? ActualVolume { get; set; }

    [ForeignKey("MarketNomId")]
    [InverseProperty("GasMarketSupplies")]
    public virtual GasMarket MarketNom { get; set; } = null!;

    [ForeignKey("SupplyNomId")]
    [InverseProperty("GasMarketSupplies")]
    public virtual GasSupply SupplyNom { get; set; } = null!;
}
