using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contract")]
[Index("ContractNum", Name = "uk_contract", IsUnique = true)]
public partial class Contract
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_num", TypeName = "citext")]
    public string ContractNum { get; set; } = null!;

    [Column("contract_name", TypeName = "citext")]
    public string ContractName { get; set; } = null!;

    [Column("is_internal_side_of_contract")]
    public bool IsInternalSideOfContract { get; set; }

    [Column("internal_entity_id")]
    public int InternalEntityId { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("status_id")]
    public int StatusId { get; set; }

    [Column("is_payment_netting_allowed")]
    public bool IsPaymentNettingAllowed { get; set; }

    [Column("effective_date")]
    public DateTime? EffectiveDate { get; set; }

    [Column("execution_date")]
    public DateTime? ExecutionDate { get; set; }

    [Column("termination_notice_date")]
    public DateTime? TerminationNoticeDate { get; set; }

    [Column("termination_effective_date")]
    public DateTime? TerminationEffectiveDate { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("signer_id")]
    public int? SignerId { get; set; }

    [Column("old_contract_info_id")]
    public int? OldContractInfoId { get; set; }

    [Column("their_contract_num", TypeName = "citext")]
    public string? TheirContractNum { get; set; }

    [Column("exhibit_b_amendment_date")]
    public DateOnly? ExhibitBAmendmentDate { get; set; }

    [Column("pay_to_bank_id")]
    public int? PayToBankId { get; set; }

    [Column("pay_from_bank_id")]
    public int? PayFromBankId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [InverseProperty("Contract")]
    public virtual ContractAccounting? ContractAccounting { get; set; }

    [InverseProperty("Contract")]
    public virtual ContractContact? ContractContact { get; set; }

    [InverseProperty("Contract")]
    public virtual ICollection<ContractCrude> ContractCrudes { get; set; } = new List<ContractCrude>();

    [InverseProperty("Contract")]
    public virtual ICollection<ContractDoc> ContractDocs { get; set; } = new List<ContractDoc>();

    [InverseProperty("Contract")]
    public virtual ICollection<ContractExhibitBSelection> ContractExhibitBSelections { get; set; } = new List<ContractExhibitBSelection>();

    [InverseProperty("Contract")]
    public virtual ICollection<ContractExhibitB> ContractExhibitBs { get; set; } = new List<ContractExhibitB>();

    [InverseProperty("Contract")]
    public virtual ContractExhibitC? ContractExhibitC { get; set; }

    [InverseProperty("Contract")]
    public virtual ContractNaesb? ContractNaesb { get; set; }

    [InverseProperty("Contract")]
    public virtual ContractOther? ContractOther { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("ContractCounterparties")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [ForeignKey("InternalEntityId")]
    [InverseProperty("ContractInternalEntities")]
    public virtual Counterparty InternalEntity { get; set; } = null!;

    [ForeignKey("PayFromBankId")]
    [InverseProperty("ContractPayFromBanks")]
    public virtual ContractPaymentType? PayFromBank { get; set; }

    [ForeignKey("PayToBankId")]
    [InverseProperty("ContractPayToBanks")]
    public virtual ContractPaymentType? PayToBank { get; set; }

    [ForeignKey("ProductId")]
    [InverseProperty("Contracts")]
    public virtual Product Product { get; set; } = null!;

    [InverseProperty("Contract")]
    public virtual ICollection<QualityBankAdjustment> QualityBankAdjustments { get; set; } = new List<QualityBankAdjustment>();

    [ForeignKey("SignerId")]
    [InverseProperty("Contracts")]
    public virtual AppUser? Signer { get; set; }

    [ForeignKey("StatusId")]
    [InverseProperty("Contracts")]
    public virtual ContractStatus Status { get; set; } = null!;
}
