using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("bank_routing")]
[Index("RoutingNum", Name = "uk_routing_num", IsUnique = true)]
public partial class BankRouting
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("routing_num", TypeName = "citext")]
    public string RoutingNum { get; set; } = null!;

    [Column("ach_name", TypeName = "citext")]
    public string? AchName { get; set; }

    [Column("ach_city", TypeName = "citext")]
    public string? AchCity { get; set; }

    [Column("ach_state_id")]
    public int? AchStateId { get; set; }

    [Column("wire_name", TypeName = "citext")]
    public string? WireName { get; set; }

    [Column("wire_city", TypeName = "citext")]
    public string? WireCity { get; set; }

    [Column("wire_state_id")]
    public int? WireStateId { get; set; }

    [Column("last_updated")]
    public DateTime? LastUpdated { get; set; }

    [Column("raw_external_response", TypeName = "citext")]
    public string? RawExternalResponse { get; set; }

    [Column("raw_external_updated")]
    public DateTime RawExternalUpdated { get; set; }

    [ForeignKey("AchStateId")]
    [InverseProperty("BankRoutingAchStates")]
    public virtual Territory? AchState { get; set; }

    [ForeignKey("WireStateId")]
    [InverseProperty("BankRoutingWireStates")]
    public virtual Territory? WireState { get; set; }
}
