using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Fast.Shared.ProgramShared.CustomEdmModel = Helper.GetCustomEdmModel();
Fast.Shared.ProgramShared.Configure(args, Type.GetType("Fast.Logic.JobsHelper"));
await Fast.Shared.ProgramShared.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            var func1 = builder.Function("GetPathingItems");
            func1.Returns<PathListItem>();

            var func2 = builder.Function("GetPathingCrudeItems");
            func2.Returns<PathListItem>();

            var func3 = builder.Function("GetPipeContractItems");
            func3.Returns<PipeContractListItem>();

            var func4 = builder.Function("GetPipeRateScheduleItems");
            func4.Returns<PipeRateScheduleListItem>();

            return builder.GetEdmModel();
        }
    }
}
