namespace Fast.Web.Models;

public class SosTransferPath
{
    public int PathId { get; set; }
    public string PathName { get; set; } = "";
    public int SourceMeterId { get; set; }
    public int SourceCounterpartyId { get; set; }

    public override string ToString()
    {
        return $"PathId: {PathId}, PathName: {PathName}, SourceMeterId: {SourceMeterId}, SourceCounterpartyId: {SourceCounterpartyId}";
    }

    public override bool Equals(object? obj)
    {
        if (obj == null || GetType() != obj.GetType())
            return false;

        var other = (SosTransferPath)obj;
        return PathId == other.PathId
            && PathName == other.PathName
            && SourceMeterId == other.SourceMeterId
            && SourceCounterpartyId == other.SourceCounterpartyId;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(PathId, PathName, SourceMeterId, SourceCounterpartyId);
    }

}
