using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class SosTransferItem
{
    public string PathName { get; set; } = "";
    [Display(Name = "Supply Ticket", Description = "100")] public string SupplyTicket { get; set; } = "";
    [Display(Name = "Receipt Pipeline", Description = "150")] public string ReceiptPipe { get; set; } = "";
    [Display(Name = "Receipt Meter", Description = "150")] public string ReceiptMeter { get; set; } = "";
    [Display(Name = "P/L Contract", Description = "100")] public int? PipeContractId { get; set; }
    [Display(Name = "PTR Contract", Description = "100")] public int? PtrContractId { get; set; }
    [Display(Name = "PTR Delivery Meter", Description = "150")] public int? PtrDeliveryMeterId { get; set; }
    [Display(Name = "PTR %", Description = "100")] public double? PtrPercent { get; set; }
    [Display(Name = "PTR Amount", Description = "100")] public double PtrAmount { get; set; }
    [Display(Name = "PTR Fuel %", Description = "100")] public double PtrFuelPercent { get; set; }
    [Display(Name = "PTR Fuel Amount", Description = "100")] public double PtrFuelAmount { get; set; }
    [Display(Name = "Total Receipt Volume", Description = "100")] public double TotalReceiptVol { get; set; }
    [Display(Name = "Nom Receipt Volume", Description = "100")] public double NomReceiptVol { get; set; }
    [Display(Name = "Nom Fuel %", Description = "100")] public double NomFuelPercent { get; set; }
    [Display(Name = "Nom Fuel Amount", Description = "100")] public double NomFuelAmount { get; set; }
    [Display(Name = "Deal Volume", Description = "100")] public double DealVolume { get; set; }
    [Display(Name = "Delivery Volume", Description = "100")] public int? DeliveryVol { get; set; }
    [Display(Name = "Delivery Pipeline", Description = "150")] public string DeliveryPipe { get; set; } = "";
    [Display(Name = "Delivery Meter", Description = "150")] public string DeliveryMeter { get; set; } = "";
    [Display(Name = "Transfer #", Description = "100")] public string? TransferNum { get; set; } = "";
    public HashSet<string> ModifiedProps { get; set; } = new();
    public string Guid { get; set; } = "";
    public string PathGuid { get; set; } = "";
    public int? SupplyDealId { get; set; }//
    public int ReceiptPipeId { get; set; }
    public int? ReceiptPointId { get; set; }//
    public int ReceiptMeterId { get; set; }//
    public int? SupplyTransferDealId { get; set; }//
    public int? MarketDealId { get; set; }//
    public int? DeliveryPointId { get; set; }//
    public int? DeliveryMeterId { get; set; }//
    public int? MarketTransferDealId { get; set; }//
    public string? ActivityNum { get; set; }
    public bool IsKeepWhole { get; set; }
    public string? SupplyNotes { get; set; }
    public string? SupplySourceNotes { get; set; }
    public string? NomNotes { get; set; }
    public int MarketTransferMeterMapId { get; set; }
    public bool IsManualPtr { get; set; }
    public bool IsEnteredFromSos { get; set; }
    public int PathLegNum { get; set; }
    public bool IsSelected { get; set; }
    public bool IsHovered { get; set; }

    public bool HasChanges()
    {
        var hasChanges = this.ModifiedProps.Count > 0;
        return hasChanges;
    }
}
