public class SosSupplyUniqueKeyComparer : EqualityComparer<SupplyUniqueKey>
{
    public override bool Equals(SupplyUniqueKey? x, SupplyUniqueKey? y)
    {
        if (x == null && y == null)
        {
            return true;
        }
        if (x == null || y == null)
        {
            return false;
        }

        return x.DealID.GetValueOrDefault() == y.DealID.GetValueOrDefault() &&
            x.Day == y.Day &&
            x.MeterID.GetValueOrDefault() == y.MeterID.GetValueOrDefault() &&
            x.PointID.GetValueOrDefault() == y.PointID.GetValueOrDefault() &&
            x.TransferDealID.GetValueOrDefault() == y.TransferDealID.GetValueOrDefault();
    }

    public override int GetHashCode(SupplyUniqueKey obj)
    {
        return obj.DealID.GetValueOrDefault().GetHashCode() ^
            obj.Day.GetHashCode() ^
            obj.MeterID.GetValueOrDefault().GetHashCode() ^
            obj.PointID.GetValueOrDefault().GetHashCode() ^
            obj.TransferDealID.GetValueOrDefault().GetHashCode();
    }
}
