namespace Fast.Models;

public class SosMarketSupply
{
    public int SupplyNomID { get; set; }
    public int MarketNomID { get; set; }
    public int? Volume { get; set; }
    public string Comment { get; set; } = "";
    public bool IsKeepWhole { get; set; }
    public int? MarketDealId { get; set; }
    public int? MarketTransferId { get; set; }
    public int? MarketMeterId { get; set; }
    public int? SupplyDealId { get; set; }
    public int? SupplyTransferId { get; set; }
    public int? SupplyMeterId { get; set; }
    public string MarketTicket { get; set; } = "";
    public int? SupplyCounterpartyId { get; set; }
    public int? PipeContractId { get; set; }
    public double? PtrPercent { get; set; }
    public int? PtrDeliveryMeterId { get; set; }
    public int? PtrContractId { get; set; }

    public override string ToString()
    {
        return $"SupplyNomID: {SupplyNomID}, MarketNomID: {MarketNomID}, Volume: {Volume}, Comment: {Comment}, IsKeepWhole: {IsKeepWhole}, " +
               $"MarketDealId: {MarketDealId}, MarketTransferId: {MarketTransferId}, MarketMeterId: {MarketMeterId}, SupplyDealId: {SupplyDealId}, " +
               $"SupplyTransferId: {SupplyTransferId}, SupplyMeterId: {SupplyMeterId}, MarketTicket: {MarketTicket}, SupplyCounterpartyId: {SupplyCounterpartyId}, " +
               $"PipeContractId: {PipeContractId}, PtrPercent: {PtrPercent}, PtrDeliveryMeterId: {PtrDeliveryMeterId}, PtrContractId: {PtrContractId}";
    }

    public override bool Equals(object? obj)
    {
        if (obj == null || GetType() != obj.GetType())
            return false;

        var other = (SosMarketSupply)obj;
        return SupplyNomID == other.SupplyNomID
            && MarketNomID == other.MarketNomID
            && Volume == other.Volume
            && Comment == other.Comment
            && IsKeepWhole == other.IsKeepWhole
            && MarketDealId == other.MarketDealId
            && MarketTransferId == other.MarketTransferId
            && MarketMeterId == other.MarketMeterId
            && SupplyDealId == other.SupplyDealId
            && SupplyTransferId == other.SupplyTransferId
            && SupplyMeterId == other.SupplyMeterId
            && MarketTicket == other.MarketTicket
            && SupplyCounterpartyId == other.SupplyCounterpartyId
            && PipeContractId == other.PipeContractId
            && PtrPercent == other.PtrPercent
            && PtrDeliveryMeterId == other.PtrDeliveryMeterId
            && PtrContractId == other.PtrContractId;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(
            SupplyNomID, MarketNomID, Volume, Comment, IsKeepWhole,
            HashCode.Combine(MarketDealId, MarketTransferId, MarketMeterId, SupplyDealId),
            HashCode.Combine(SupplyTransferId, SupplyMeterId, MarketTicket, SupplyCounterpartyId),
            HashCode.Combine(PipeContractId, PtrPercent, PtrDeliveryMeterId, PtrContractId)
        );
    }

}
