using System.ComponentModel.DataAnnotations.Schema;

namespace Fast.Models;

public class SosMarket
{
    public string MarketTicket { get; set; } = "";
    public string MarketDealType { get; set; } = "";
    public int? MarketDeliveryMeterId { get; set; }
    public string MarketCounterparty { get; set; } = "";
    public int MarketCounterpartyId { get; set; }
    public double MarketDealVolume { get; set; }
    [NotMapped] public double TotalMarketNomVol { get; set; } = 0;
    public int? MarketNomId { get; set; }
    public int? MarketDealId { get; set; }
    public string? ContractNumber { get; set; }
    public int? PointId { get; set; }
    public string? PointName { get; set; }
    [NotMapped] public string Guid { get; set; } = System.Guid.NewGuid().ToString("N")[..8];

    public override string ToString()
    {
        return $"MarketTicket: {MarketTicket}, MarketDealType: {MarketDealType}, MarketDeliveryMeterId: {MarketDeliveryMeterId}, " +
               $"MarketCounterparty: {MarketCounterparty}, MarketCounterpartyId: {MarketCounterpartyId}, MarketDealVolume: {MarketDealVolume}, " +
               $"TotalMarketNomVol: {TotalMarketNomVol}, MarketNomId: {MarketNomId}, MarketDealId: {MarketDealId}, ContractNumber: {ContractNumber}, " +
               $"PointId: {PointId}, PointName: {PointName}, Guid: {Guid}";
    }

    public override bool Equals(object? obj)
    {
        if (obj == null || GetType() != obj.GetType())
            return false;

        var other = (SosMarket)obj;
        return MarketTicket == other.MarketTicket
            && MarketDealType == other.MarketDealType
            && MarketDeliveryMeterId == other.MarketDeliveryMeterId
            && MarketCounterparty == other.MarketCounterparty
            && MarketCounterpartyId == other.MarketCounterpartyId
            && MarketDealVolume == other.MarketDealVolume
            && TotalMarketNomVol == other.TotalMarketNomVol
            && MarketNomId == other.MarketNomId
            && MarketDealId == other.MarketDealId
            && ContractNumber == other.ContractNumber
            && PointId == other.PointId
            && PointName == other.PointName
        // && Guid == other.Guid // Exclude Guid from comparison
        ;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(
            // Guid, // Exclude Guid from hash code calculation
            MarketTicket, MarketDealType, MarketDeliveryMeterId, MarketCounterparty, MarketCounterpartyId,
            HashCode.Combine(MarketDealVolume, TotalMarketNomVol, MarketNomId),
            HashCode.Combine(MarketDealId, ContractNumber, PointId, PointName)
        );
    }

}
