﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class PipeContractListItem
{
    [Key] //need to set primary key for OData
    public int Id { get; set; }

    [Display(Name = "Contract #")] public string ContractNum { get; set; } = "";
    [Display(Name = "Start Date")] public DateOnly StartDate { get; set; }
    [Display(Name = "End Date")] public DateOnly? EndDate { get; set; }
    [Display(Name = "Pipeline")] public string Pipeline { get; set; } = "";
    [Display(Name = "Contract Type")] public string ContractType { get; set; } = "";
    [Display(Name = "Rate Schedule")] public string RateSchedule { get; set; } = "";
    [Display(Name = "Shipper")] public string Shipper { get; set; } = "";
    [Display(Name = "Contract Owner")] public string ContractOwner { get; set; } = "";
    [Display(Name = "Capacity Release?")] public string CapacityRelease { get; set; } = "";
    [Display(Name = "Capacity Counterparty")] public string CapacityCounterparty { get; set; } = "";
    [Display(Name = "Receipt Zones")] public string ReceiptZones { get; set; } = "";
    [Display(Name = "Receipt Meters")] public string ReceiptMeters { get; set; } = "";
    [Display(Name = "Delivery Zones")] public string DeliveryZones { get; set; } = "";
    [Display(Name = "Delivery Meters")] public string DeliveryMeters { get; set; } = "";
    [Display(Name = "Default Contract")] public string IsDefaultContract { get; set; } = "";
    [Display(Name = "PTR Contract")] public string IsPtrContract { get; set; } = "";
    [Display(Name = "Default PTR")] public string IsDefaultPtrContract { get; set; } = "";
    [Display(Name = "Product")] public string Product { get; set; } = "";
}
