import { TooltipDirective } from '@progress/kendo-angular-tooltip';
import * as models from './models';
import * as util from '../_shared/utils/util';
import { FormGroup } from '@angular/forms';

export enum AdjustType {
  ForDisplay,
  ForSave
}

export class SosHelper {
  public static adjustPercents(items: models.SosItem[] | models.SosTransferItem[], adjustType: AdjustType): void {
    items.forEach((item: models.SosItem | models.SosTransferItem) => {
      item.ptrPercent = adjustType === AdjustType.ForDisplay ? item.ptrPercent * 100 : item.ptrPercent / 100;
      item.ptrFuelPercent = adjustType === AdjustType.ForDisplay ? item.ptrFuelPercent * 100 : item.ptrFuelPercent / 100;
      item.nomFuelPercent = adjustType === AdjustType.ForDisplay ? item.nomFuelPercent * 100 : item.nomFuelPercent / 100;
    });
  }

  public static showMainTooltip(e: MouseEvent, tooltipMain: TooltipDirective): void {
    const triggerElement = e.target as HTMLElement;
    let contentElement = triggerElement;
    let anchorElem = triggerElement;

    const cellMain = triggerElement.closest('.cellMain') as HTMLElement;
    if (cellMain) {
      anchorElem = cellMain;
      contentElement = util.getInnerMostChildElement(triggerElement);
    }

    if (contentElement && contentElement.children.length === 0 && util.isClipped(contentElement)) {
      const anchorText: string = contentElement instanceof HTMLInputElement ? contentElement.value : contentElement.innerText;
      anchorElem.setAttribute('anchorText', anchorText);
      tooltipMain.hide();
      tooltipMain.show(anchorElem);
    }
    else
      tooltipMain.hide();
  }

  public static isMissingRequiredInfo(sosItem: models.SosItem | models.SosTransferItem = null): boolean {
    const hasPtrPercent = sosItem && (sosItem?.ptrPercent ?? 0) !== 0;
    const isMissingPtrContract = sosItem && hasPtrPercent && !sosItem?.ptrContractId;
    const isMissingPtrMeter = sosItem && hasPtrPercent && !sosItem?.ptrDeliveryMeterId;
    const hasAnyNomVols = 'noms' in sosItem && sosItem?.noms?.some(nom => nom?.volume);
    const hasTransferDeliveryVol = 'pathName' in sosItem && sosItem?.deliveryVol;
    const hasAnyVol = hasTransferDeliveryVol || hasAnyNomVols;
    const isMissingPipeContract = sosItem && hasAnyVol && !sosItem?.pipeContractId;
    const hasMissingRequiredInfo = isMissingPipeContract || isMissingPtrContract || isMissingPtrMeter

    return hasMissingRequiredInfo;
  }

  public static setSelectedItem(allForms: FormGroup[], formToSelect: FormGroup) {
    allForms.filter(x => x.get('isSelected').value === true).forEach(x => x.patchValue({ isSelected: false }));
    allForms.filter(x => x.get('isHovered').value === true).forEach(x => x.patchValue({ isHovered: false }));
    if (formToSelect)
      formToSelect.patchValue({ isSelected: true });
  }

  public static setHoveredItem(allForms: FormGroup[], formToHover: FormGroup) {
    allForms.filter(x => x.get('isHovered').value === true).forEach(x => x.patchValue({ isHovered: false }, { emitEvent: false }));
    if (formToHover)
      formToHover.patchValue({ isHovered: true }, { emitEvent: false });
  }
}
