import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { SosItem } from '../models';
import dayjs from 'dayjs';

export interface SosSettingItem {
  pipeId: number;
  fontSize: number;
  frozenColumnCount: number;
  displayInfos: DisplayInfo[];
}

export interface DisplayInfo {
  propName: string;
  displayName: string;
  width: number;
  order: number;
}

export interface RequiredData {
  currentTransferStartDate: Date;
  currentTransferEndDate: Date;
  sourceSupplyStartDate: Date;
  sourceSupplyEndDate: Date;
}

@Injectable({
  providedIn: 'root'
})
export class SosSaveService {
  private baseUrl = `${window.location.origin}/api/Sos`;
  http = inject(HttpClient);

  getRequiredData(item: SosItem) {
    const url = `${this.baseUrl}/GetChangeTransferRequiredData?transferDealId=${item.transferDealId}&transferSourceTicket=${item.sourceTicket}`;
    return this.http.get<RequiredData>(url);
  }

  changeDates(item: SosItem, fromDate: Date, toDate: Date) {
    const fromDateStr = dayjs(fromDate).format("YYYY-MM-DD");
    const toDateStr = dayjs(toDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/ChangeTransferDates?transferDealId=${item.transferDealId}&transferSourceTicket=${item.sourceTicket}&fromDate=${fromDateStr}&toDate=${toDateStr}`;
    return this.http.put(url, null);
  }
}
