import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { SosItem, SosTransferItem } from '../models';
import dayjs from 'dayjs';
import { AdjustType, SosHelper } from '../sosHelper';

export interface SosSettingItem {
  pipeId: number;
  fontSize: number;
  frozenColumnCount: number;
  displayInfos: DisplayInfo[];
}

export interface DisplayInfo {
  propName: string;
  displayName: string;
  width: number;
  order: number;
}

@Injectable({
  providedIn: 'root'
})
export class SosSaveService {
  http = inject(HttpClient);

  // saveNoms(items: SosItem[], fromDate: Date, toDate: Date, saveNotes: string, deliveryPointId: number) {
  //   const fromDateStr = dayjs(fromDate).format("YYYY-MM-DD");
  //   const toDateStr = dayjs(toDate).format("YYYY-MM-DD");
  //   const url = `${window.location.origin}/api/Sos/SaveNoms?fromDate=${fromDateStr}&toDate=${toDateStr}&deliveryPointId=${deliveryPointId}`;
  //   SosHelper.adjustPercents(items, AdjustType.ForSave);
  //   return this.http.put<number>(url, items);
  // }

  saveNoms(items: SosItem[], fromDate: Date, toDate: Date, saveNotes: string, deliveryPointId: number) {
    const fromDateStr = dayjs(fromDate).format('YYYY-MM-DD');
    const toDateStr = dayjs(toDate).format('YYYY-MM-DD');
    const url = `${window.location.origin}/api/Sos/SaveNoms?fromDate=${fromDateStr}&toDate=${toDateStr}&deliveryPointId=${deliveryPointId}`;
    SosHelper.adjustPercents(items, AdjustType.ForSave);
    const payload = { items: items, saveNotes: saveNotes };
    return this.http.put<number>(url, payload);
  }

  savePathNoms(items: SosTransferItem[], fromDate: Date, toDate: Date) {
    const fromDateStr = dayjs(fromDate).format("YYYY-MM-DD");
    const toDateStr = dayjs(toDate).format("YYYY-MM-DD");
    const url = `${window.location.origin}/api/SosTransfers/SavePathNoms?fromDate=${fromDateStr}&toDate=${toDateStr}`;
    SosHelper.adjustPercents(items, AdjustType.ForSave);
    return this.http.put<number>(url, items);
  }
}
