import { Pipe, PipeTransform } from '@angular/core';
import { SosPipeContractInfo } from '../models/SosPipeContractInfo';
import { SosItem } from '../models/SosItem';

@Pipe({
  name: 'sosSupplyPipelineContracts'
})
export class SupplyPipelineContractsPipe implements PipeTransform {
  transform(contracts: SosPipeContractInfo[], item: SosItem): SosPipeContractInfo[] {
    if (!contracts) return [];
    return contracts.filter(c => c.productId === item?.sourceDealProduct);
  }
}
