import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'sosMarketVolColor'
})
export class SosMarketVolColorPipe implements PipeTransform {
  transform(originalClasses: string, totalMarketNomVol: number, marketDealVolume: number): string {
    let newClasses = '';

    if (totalMarketNomVol > marketDealVolume)
      newClasses = 'marketVolIsOver';
    else if (totalMarketNomVol < marketDealVolume)
      newClasses = 'marketVolIsUnder';
    else
      newClasses = 't-bg-color1';

    return originalClasses + ' ' + newClasses;
  }
}
