import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'sosMarketHeight'
})
export class SosMarketHeightPipe implements PipeTransform {
  transform(fontSizeStr: string): string {
    const fontSize = parseInt(fontSizeStr.replace('px', ''));
    const marketColHeight = (fontSize * 5) + (fontSize * 0.25 * 5) + 6;
    return marketColHeight > 0 ? marketColHeight + "px" : "0";
  }
}
