import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import * as util from '../../_shared/utils/util';

export interface Item {
  PathId: number;
  PathName: string;
  ContractOwners: string;
  ContractNums: string;
  SourceMeter: string;
  SourceCounterparty: string;
}

export interface Detail {
  pathId: number;
  pathName: string;
  sourceCounterpartyId: number;
  sourceMeterId: number;
  sourcePipeId: number;
  sourceContractId: number;
  pathRoutes: PathRouteItem[];
  sourceSubMeterId: number;
  sourceSubPipeId: number;
  sourceFromPipeId: number;
  sourceSubContractId: number;
}

export interface TransferMeterMapItem {
  transferMeterMapId: number;
  transferMeterMapName: string;
  pipe1Id: number;
  pipe2Id: number;
  meter1Id: number;
  meter2Id: number;
  meter1Name: string;
  meter2Name: string;
  isMeter1First: boolean;
}
export interface PathRouteItem {
  pipeId: number;
  pipeName: string;
  meterName: string;
  contractNum: string;
  contractOwner: string;
  contractId: number;
  meterMapId: number;
  isMeter1First: boolean;
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

export interface PathingData {
  hasModifyPermission: boolean;
  contracts: PathContract[];
  counterparties: util.IdName[];
  pipelines: util.IdName[];
  meters: MeterItem[];
}

export interface PathContract {
  contractId: number;
  contractNum: string;
  contractOwner: string;
  contractDesc: string;
  contractCounterpartyId: number;
  contractPipeId: number;
}

export interface MeterItem {
  meterId: number;
  meterName: string;
  meterNum: string;
  zoneId: number;
  pipeId: number;
}

export enum SaveType {
  New = 1,
  Normal = 2
}

@Injectable({
  providedIn: 'root'
})
export class PathingService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/Pathing`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<PathingData>(`${this.baseUrl}/getRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetPathingItems`, state, null, false)
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetPathingItems`, state, null, fileNameOriginal);
  }

  getTransferMeterMaps(fromPipe: number, toPipe: number): Observable<TransferMeterMapItem[]> {
    const url = `${this.baseUrl}/GetTransferMeterMaps/${fromPipe}/${toPipe}`;
    return this.http.get<TransferMeterMapItem[]>(url);
  }

}
