export interface SosContextMenuOption {
  text: string;
  class: string;
}

export const SosContextMenuOptions = {
  HideRow: { text: "Hide Row", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  ShowRow: { text: "Show Row", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  KeepWhole: { text: "Keep Whole", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  DeleteTransfersInPath: { text: "Delete Transfers in Path", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  EditNomNote: { text: "Edit Nom Note", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  AddSupplyDeal: { text: "Add Supply Deal", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  AddMarketDeal: { text: "Add Market Deal", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  AddTransferDeal: { text: "Add Transfer Deal", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  CloneSupplyRow: { text: "Clone Supply Row", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  ResetSupplyRow: { text: "Reset Supply Row", class: "app-sos contextMenuItem" } as SosContextMenuOption,
  ChangeTransferDates: { text: "Change Transfer Dates", class: "app-sos contextMenuItem" } as SosContextMenuOption
}

//https://www.telerik.com/kendo-angular-ui/components/menus/contextmenu/items/
export interface SosContextItem {
  menuOption: SosContextMenuOption; //custom
  text: string; //standard
  cssClass: string; //standard
  disabled: boolean; //standard
}
