import { Component, ViewEncapsulation, ChangeDetectionStrategy, ChangeDetectorRef, Input, Output, EventEmitter, HostBinding, OnChanges, SimpleChanges } from '@angular/core';
import { DisplayInfo } from '../sos-settings/sos-settings.service';
import { SosItem, SosNom, SosTransferItem } from '../models';
import { ControlContainer, FormGroupDirective } from '@angular/forms';
import { ContextMenuSelectEvent, KENDO_CONTEXTMENU } from '@progress/kendo-angular-menu';
import { NgClass } from '@angular/common';
import { SosContextItemsPipe } from '../pipes/sos-context-items.pipe';
import { SosCellOverlayColorsPipe } from '../pipes/sos-cell-overlay-colors.pipe';
import { FAST_PAGE_COMMON } from '../../app.config';
import { KENDO_TEXTBOX } from '@progress/kendo-angular-inputs';

@Component({
  selector: 'app-sos-gas-elem-text-input[frozen][propName][sosItem][display][frozenColCount][activeElement][itemIdx][fontSizeStr][isPathEnd]',
  templateUrl: './sos-elem-text-input.html',
  styleUrls: ['./sos-elem-text-input.scss'],
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  viewProviders: [{ provide: ControlContainer, useExisting: FormGroupDirective }],
  imports: [FAST_PAGE_COMMON, KENDO_TEXTBOX, KENDO_CONTEXTMENU, NgClass, SosContextItemsPipe, SosCellOverlayColorsPipe]
})
export class SosElemTextInputComponent implements OnChanges {
  @HostBinding('style.display') hostDisplay: string = 'flex';
  @HostBinding('style.order') componentOrder: number = 0;
  @Input() frozen: boolean;
  @Input() propName: keyof SosItem | keyof SosTransferItem | keyof SosNom;
  @Input() sosItem: SosItem | SosTransferItem;
  @Input() display: DisplayInfo;
  @Input() frozenColCount: number;
  @Input() activeElement: Element;
  @Input() itemIdx: number;
  @Input() fontSizeStr: string;
  @Input() isPathEnd: boolean;
  @Input() numFormat: string;
  @Input() isLoading: boolean = false;
  @Input() hasContextMenu: boolean = true;

  @Output() contextSelect = new EventEmitter<ContextMenuSelectEvent>();

  sosNom: SosNom = null;
  isTransferItem = false;
  isHidden = false;
  isNomVolume = false;
  isSupplyTransfer = false;

  constructor(private ref: ChangeDetectorRef) {
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes.display)
      this.componentOrder = this.display?.order ?? 0;

    this.isSupplyTransfer = this.sosItem && 'supplyNomId' in this.sosItem && this.sosItem.transferDealId !== null;
    this.isTransferItem = this.sosItem && 'pathName' in this.sosItem ? true : false;
    this.isHidden = this.sosItem && 'isHidden' in this.sosItem ? this.sosItem.isHidden : false;
    this.isNomVolume = this.sosNom !== null;
  }
}
