import { Component, ViewEncapsulation, ChangeDetectionStrategy, ChangeDetectorRef, OnInit, Input, Output, EventEmitter, HostBinding, OnChanges, SimpleChanges } from '@angular/core';
import { DisplayInfo } from '../sos-settings/sos-settings.service';
import { SosItem, SosNom, SosTransferItem } from '../models';
import { ControlContainer, FormArray, FormGroup, FormGroupDirective } from '@angular/forms';
import { ContextMenuSelectEvent, KENDO_CONTEXTMENU } from '@progress/kendo-angular-menu';
import * as util from '../../_shared/utils/util';
import { NgClass } from '@angular/common';
import { SosCellOverlayColorsPipe } from '../pipes/sos-cell-overlay-colors.pipe';
import { SosContextItemsPipe } from '../pipes/sos-context-items.pipe';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';

@Component({
  selector: 'app-sos-gas-elem-numeric-input[frozen][propName][sosItem][display][frozenColCount][activeElement][itemIdx][fontSizeStr][isPathEnd]',
  templateUrl: './sos-elem-numeric-input.html',
  styleUrls: ['./sos-elem-numeric-input.scss'],
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  viewProviders: [{ provide: ControlContainer, useExisting: FormGroupDirective }],
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON, KENDO_CONTEXTMENU, NgClass, SosContextItemsPipe, SosCellOverlayColorsPipe]
})
export class SosElemNumericInputComponent implements OnChanges, OnInit {
  @HostBinding('style.display') hostDisplay: string = 'flex';
  @HostBinding('style.order') componentOrder: number = 0;
  @Input() frozen: boolean;
  @Input() propName: keyof SosItem | keyof SosTransferItem | keyof SosNom;
  @Input() sosItem: SosItem | SosTransferItem = null;
  @Input() display: DisplayInfo;
  @Input() frozenColCount: number;
  @Input() activeElement: Element;
  @Input() itemIdx: number;
  @Input() fontSizeStr: string;
  @Input() isPathEnd: boolean;
  @Input() numFormat: string;
  @Input() decimals: number;
  @Input() sosNom: SosNom = null;
  @Input() nomRowIdx: number;
  @Input() isLoading: boolean = false;
  @Input() hasContextMenu: boolean = true;

  @Output() contextSelect = new EventEmitter<ContextMenuSelectEvent>();
  @Output() valueChange = new EventEmitter();

  icons = util.icons;
  isTransferItem = false;
  isHidden = false;
  isNomVolume = false;
  isSupplyTransfer = false;
  sosTransferItem: SosTransferItem = null;
  isKeepWhole: boolean = false;
  hasNomNote: boolean = false;
  hoverNote: string = '';
  sosTipClass: string = '';
  iconFontSizeStr: string = '';
  formArray: FormArray;
  formGroup: FormGroup;
  public isActive: boolean = false;

  constructor(private ref: ChangeDetectorRef, private controlContainer: ControlContainer, private formGroupDirective: FormGroupDirective) {
  }

  ngOnInit(): void {
    const form = this.formGroupDirective.form;
    this.formArray = form.get('items') as FormArray;
    if (this.formArray.length > 0) {
      this.formGroup = this.formArray.at(this.itemIdx) as FormGroup;
    }
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes.display)
      this.componentOrder = this.display?.order ?? 0;

    const fontSizeNum = parseInt(this.fontSizeStr.replace('px', ''));
    this.sosTipClass = 'app-sosTip-' + fontSizeNum;
    this.iconFontSizeStr = (fontSizeNum + 1) + 'px';

    if (this.sosItem) {
      const isDeliveryVolume = this.propName === 'deliveryVol';
      this.isSupplyTransfer = this.sosItem && 'supplyNomId' in this.sosItem && this.sosItem.transferDealId !== null;
      this.isTransferItem = this.sosItem && 'pathName' in this.sosItem ? true : false;
      this.isHidden = this.sosItem && 'isHidden' in this.sosItem ? this.sosItem.isHidden : false;
      this.isNomVolume = this.sosNom !== null;
      this.sosTransferItem = this.isTransferItem ? this.sosItem as SosTransferItem : null;
      this.isKeepWhole = this.isNomVolume ? (this.sosNom?.isKeepWhole ?? false) : isDeliveryVolume ? (this.sosTransferItem?.isKeepWhole ?? false) : false;
      this.hasNomNote = this.isNomVolume ? !util.isNullOrWhitespace(this.sosNom?.notes) : isDeliveryVolume ? !util.isNullOrWhitespace(this.sosTransferItem?.nomNotes) : false;
      this.hoverNote = this.isKeepWhole ? 'Keep Whole' : '';
      this.hoverNote += this.isKeepWhole && this.hasNomNote ? ' | ' : '';;
      this.hoverNote += this.hasNomNote ? this.isTransferItem ? this.sosTransferItem?.nomNotes : this.sosNom?.notes : '';
    }
  }

  setActiveState(isActive: boolean): void {
    this.isActive = isActive;
  }
}
