import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import dayjs from 'dayjs';
import * as models from './models';
import { SosItem } from './models';

export enum SaveType {
  New = 1,
  Normal = 2
}

@Injectable({
  providedIn: 'root'
})
export class SosService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/SosCrude`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<models.RequiredData>(`${this.baseUrl}/getRequiredData`)

  getDataSet(pipeId: number, nomDate: Date): Observable<models.SosDataSet> {
    // replace null/undefined with 0
    pipeId = pipeId ?? 0;

    const nomDateStr = dayjs(nomDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/GetDataSet?pipeId=${pipeId}&nomDate=${nomDateStr}`;
    return this.http.get<models.SosDataSet>(url);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetPathingItems`, state, null, fileNameOriginal);
  }

  getItemDynamicValues(item: SosItem, pipeId: number, nomDate: Date): Observable<SosItem> {
    const nomDateStr = dayjs(nomDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/GetItemDynamicValues?pipeId=${pipeId}&nomDate=${nomDateStr}`;
    return this.http.put<SosItem>(url, item);
  }

  cloneSupply(item: SosItem) {
    const url = `${this.baseUrl}/CloneSupply?supplyNomId=${item.supplyNomId}`;
    return this.http.put(url, null);
  }
}
