import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import * as models from '../models';
import dayjs from 'dayjs';
import { SosItem } from '../models';

@Injectable({
  providedIn: 'root'
})
export class SosTransfersService {
  private baseUrl = `${window.location.origin}/api/SosCrudeTransfers`;
  http = inject(HttpClient);

  getRequiredData(dealId: number): Observable<models.SosTransferData> {
    const url = `${this.baseUrl}/GetRequiredData?dealId=${dealId}`;
    return this.http.put<models.SosTransferData>(url, null);
  }

  getRequiredDataForTransferDeal(transferDealId: number, nomDate: string): Observable<models.SosTransferData> {
    const url = `${this.baseUrl}/GetRequiredDataForTransferDeal?transferDealId=${transferDealId}&nomDate=${nomDate}`;
    return this.http.put<models.SosTransferData>(url, null);
  }

  getRequiredDataForActualTneMeter(item: models.ActualItem): Observable<models.SosTransferData> {
    const url = `${this.baseUrl}/getRequiredDataForActualTneMeter`;
    return this.http.put<models.SosTransferData>(url, item);
  }

  getTransferSet(sourceItem: SosItem, nomDate: Date): Observable<models.SosTransferSet> {
    const nomDateStr = dayjs(nomDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/GetTransferSet?nomDate=${nomDateStr}`;
    return this.http.put<models.SosTransferSet>(url, sourceItem);
  }

  getTransferSetForDeal(dealId: number): Observable<models.SosTransferSet> {
    const url = `${this.baseUrl}/GetTransferSetForDeal?dealId=${dealId}`;
    return this.http.put<models.SosTransferSet>(url, null);
  }

  getTransferSetForTneMeter(item: models.ActualItem): Observable<models.SosTransferSet> {
    const url = `${this.baseUrl}/GetTransferSetForTneMeter`;
    return this.http.put<models.SosTransferSet>(url, item);
  }

  getTransferSetForTransferDeal(transferDealId: number, nomDate: string): Observable<models.SosTransferSet> {
    const url = `${this.baseUrl}/GetTransferSetForTransferDeal?transferDealId=${transferDealId}&nomDate=${nomDate}`;
    return this.http.put<models.SosTransferSet>(url, null);
  }

  deleteTransfersInPath(sourceItem: SosItem, nomDate: Date, anyTransferDealId: number): Observable<object> {
    const nomDateStr = dayjs(nomDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/DeleteTransfersInPath?nomDate=${nomDateStr}&anyTransferDealId=${anyTransferDealId}`;
    return this.http.put<object>(url, sourceItem);
  }

  saveTneMeter(dealId: number, tneMeterId: number): Observable<void> {
    if (tneMeterId === null || tneMeterId === undefined) {
      tneMeterId = 0;
    }

    const url = `${this.baseUrl}/SaveTneMeter?dealId=${dealId}&tneMeterId=${tneMeterId}`;
    // console.log(url);
    return this.http.put<void>(url, null);
  }

  saveActualTneMeter(item: models.ActualItem): Observable<void> {
    const url = `${this.baseUrl}/SaveActualTneMeter`;
    return this.http.put<void>(url, item);
  }

}
