import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { SosItem } from '../models';
import dayjs from 'dayjs';

export interface SosSettingItem {
  pipeId: number;
  fontSize: number;
  frozenColumnCount: number;
  displayInfos: DisplayInfo[];
}

export interface DisplayInfo {
  propName: string;
  displayName: string;
  width: number;
  order: number;
}

@Injectable({
  providedIn: 'root'
})
export class SosSaveService {
  private baseUrl = `${window.location.origin}/api/SosCrude`;
  http = inject(HttpClient);

  resetSupply(item: SosItem, fromDate: Date, toDate: Date) {
    const fromDateStr = dayjs(fromDate).format("YYYY-MM-DD");
    const toDateStr = dayjs(toDate).format("YYYY-MM-DD");
    const url = `${this.baseUrl}/ResetSupply?supplyNomId=${item.supplyNomId}&fromDate=${fromDateStr}&toDate=${toDateStr}`;
    return this.http.put(url, null);
  }
}
