import { Component, ChangeDetectionStrategy, Output, EventEmitter, Input, OnInit, ViewEncapsulation } from '@angular/core';
import * as util from '../../_shared/utils/util';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../../app.config';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-sos-crude-note[note]',
  templateUrl: './sos-note.component.html',
  styleUrls: ['./sos-note.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  encapsulation: ViewEncapsulation.None,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON, FormsModule]
})
export class SosNoteComponent implements OnInit {
  @Input() note: string;
  @Input() fontSizeStr: string;
  @Output() noteChanged = new EventEmitter<string>()
  @Output() closed = new EventEmitter<boolean>()

  util = util;
  icons = util.icons;

  constructor() {

  }

  ngOnInit(): void {
    util.focusInputByClassName('noteBox');
  }

  ok() {
    this.noteChanged.emit(this.note);
  }

  close() {
    this.closed.emit(false);
  }

  remove() {
    this.noteChanged.emit('');
  }
}
