import { Component, ChangeDetectionStrategy, ChangeDetectorRef, Output, EventEmitter, ViewEncapsulation, Input, OnChanges } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { MessageService } from '../../_shared/services/message.service';
import { CustomFormBuilder } from '../../_shared/services/custom-form-builder.service';
import { DialogService } from '@progress/kendo-angular-dialog';
import { NotifyService } from '../../_shared/services/notify.service';
import * as util from '../../_shared/utils/util';
import { FAST_PAGE_COMMON, FAST_KENDO_COMMON } from '../../app.config';

@Component({
  selector: 'app-sos-crude-legend[fontSizeStr]',
  templateUrl: './sos-legend.component.html',
  styleUrls: ['./sos-legend.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  encapsulation: ViewEncapsulation.None,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON]
})
export class SosLegendComponent implements OnChanges {
  @Input() fontSizeStr: string;
  @Output() closed = new EventEmitter<boolean>()

  icons = util.icons;
  iconFontSizeStr: string = '';
  viewWidth = 250;

  constructor(private messageService: MessageService, private titleService: Title, private fb: CustomFormBuilder, private ref: ChangeDetectorRef, private dialogService: DialogService, private notify: NotifyService) {

  }

  ngOnChanges(): void {
    const fontSizeNum = parseInt(this.fontSizeStr.replace('px', ''));
    this.iconFontSizeStr = (fontSizeNum + 1) + 'px'
  }

  close() {
    this.closed.emit(false);
  }

  getLegendLeftPos(): number {
    return window.innerWidth - this.viewWidth - 50;
  }
}
