import { Pipe, PipeTransform } from '@angular/core';
import { SosItem, SosTransferItem } from '../models';

@Pipe({
  name: 'sosRowMainColorsCrude'
})
export class SosRowMainColorsPipe implements PipeTransform {
  transform(originalClasses: string, sosItem: SosItem | SosTransferItem): string {
    let newClasses = '';
    const isTransfer = 'pathName' in sosItem;
    const isAlternateRow = sosItem.rowNum % 2 === 1;
    const isSelected = sosItem.isSelected;
    const isHovered = sosItem.isHovered;
    const isHidden = 'noms' in sosItem && sosItem.isHidden;

    if (isSelected && isHovered)
      newClasses = 'isSelected isHovered t-bg-hover3 t-text-color-blackAndWhite'
    else if (isSelected)
      newClasses = 'isSelected t-bg-hover3 t-text-color-blackAndWhite';
    else if (isHovered)
      newClasses = 'isHovered t-bg-hover4 blackText';
    else if (!isHidden && isAlternateRow && !isTransfer)
      newClasses = 'isAlternate t-bg-alt-4';
    else
      newClasses = 'isDefault t-bg-color1'; //defaultRow

    return originalClasses + ' ' + newClasses;
  }
}
