import { Pipe, PipeTransform } from '@angular/core';
import { MarketDealType } from '../models';
import { transferColWidth, marketColWidth } from '.././sos.component';
import { getTextWidth } from '../../_shared/utils/util';

@Pipe({
  name: 'sosMarketPositionCrude'
})
export class SosMarketPositionPipe implements PipeTransform {
  transform(marketType: MarketDealType, swingColCount: number, baseloadColCount: number, fontSizeStr: string): string {
    const font = `700 ${fontSizeStr} "Helvetica Neue", Helvetica, Arial, "sans-serif"`;
    const swingTextWidth = getTextWidth("Swing Markets", font);
    const baseloadTextWidth = getTextWidth("Baseload Markets", font);
    const transferTextWidth = getTextWidth("Transfers", font);

    let leftPos = 0;
    const marketColWidthEx = marketColWidth + 3 + 0.8;
    const transferColWidthEx = transferColWidth + 3 + 0.8;

    if (marketType === MarketDealType.Swing)
      leftPos = (marketColWidthEx * swingColCount / 2) - (swingTextWidth / 2);
    else if (marketType === MarketDealType.Baseload)
      leftPos = ((marketColWidthEx * baseloadColCount / 2) - (baseloadTextWidth / 2));
    else if (marketType === MarketDealType.Transfer)
      leftPos = (transferColWidthEx / 2) - (transferTextWidth / 2)

    return leftPos > 0 ? leftPos + "px" : "0";
  }
}
