import { Pipe, PipeTransform } from '@angular/core';
import { MeterInfo } from '../models/MeterInfo';

@Pipe({
  name: 'sosMarketMetersForPoint'
})
export class MarketMetersForPointPipe implements PipeTransform {
  transform(meters: MeterInfo[], pointId: number): MeterInfo[] {
    if (!meters || !pointId) {
      return [];
    }

    const pointMeters = meters.filter(meter => meter.pointIds?.includes(pointId));
    return pointMeters;
  }
}
