import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'sosMarketHeightCrude'
})
export class SosMarketHeightPipe implements PipeTransform {
  transform(fontSizeStr: string): string {
    const fontSize = parseInt(fontSizeStr.replace('px', ''));
    const linesInColumn = 7;
    const marketColHeight = (fontSize * linesInColumn) + (fontSize * 0.25 * linesInColumn) + 6;
    return marketColHeight > 0 ? marketColHeight + "px" : "0";
  }
}
