import { Pipe, PipeTransform } from '@angular/core';
import { SosContextItem, SosContextMenuOptions } from '../models';

@Pipe({
  name: 'sosContextItemsCrude'
})
export class SosContextItemsPipe implements PipeTransform {
  transform(isSupplyTransfer: boolean, isTransferItem: boolean, isHidden: boolean, isNomVolume: boolean, isPathEnd: boolean): SosContextItem[] {
    const contextMenuItems: SosContextItem[] = [];

    if (isTransferItem && !isPathEnd) {
      contextMenuItems.push({ menuOption: SosContextMenuOptions.EditNomNote, text: SosContextMenuOptions.EditNomNote.text, cssClass: SosContextMenuOptions.EditNomNote.class, disabled: false });
      contextMenuItems.push({ menuOption: SosContextMenuOptions.KeepWhole, text: SosContextMenuOptions.KeepWhole.text, cssClass: SosContextMenuOptions.KeepWhole.class, disabled: false });
      contextMenuItems.push({ menuOption: SosContextMenuOptions.DeleteTransfersInPath, text: SosContextMenuOptions.DeleteTransfersInPath.text, cssClass: SosContextMenuOptions.DeleteTransfersInPath.class, disabled: false });
    }
    else if (isTransferItem && isPathEnd)
      contextMenuItems.push({ menuOption: SosContextMenuOptions.DeleteTransfersInPath, text: SosContextMenuOptions.DeleteTransfersInPath.text, cssClass: SosContextMenuOptions.DeleteTransfersInPath.class, disabled: false });
    else if (!isTransferItem) {
      if (!isNomVolume && !isSupplyTransfer && !isNomVolume) { //normal supply
        contextMenuItems.push({ menuOption: SosContextMenuOptions.AddSupplyDeal, text: SosContextMenuOptions.AddSupplyDeal.text, cssClass: SosContextMenuOptions.AddSupplyDeal.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.AddTransferDeal, text: SosContextMenuOptions.AddTransferDeal.text, cssClass: SosContextMenuOptions.AddTransferDeal.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.CloneSupplyRow, text: SosContextMenuOptions.CloneSupplyRow.text, cssClass: SosContextMenuOptions.CloneSupplyRow.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.ResetSupplyRow, text: SosContextMenuOptions.ResetSupplyRow.text, cssClass: SosContextMenuOptions.ResetSupplyRow.class, disabled: false });
      }
      else if (isSupplyTransfer && !isNomVolume) { //supply transfer
        contextMenuItems.push({ menuOption: SosContextMenuOptions.AddTransferDeal, text: SosContextMenuOptions.AddTransferDeal.text, cssClass: SosContextMenuOptions.AddTransferDeal.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.DeleteTransfersInPath, text: SosContextMenuOptions.DeleteTransfersInPath.text, cssClass: SosContextMenuOptions.DeleteTransfersInPath.class, disabled: false });
      }
      else if (isNomVolume) { //nom volume {
        contextMenuItems.push({ menuOption: SosContextMenuOptions.AddMarketDeal, text: SosContextMenuOptions.AddMarketDeal.text, cssClass: SosContextMenuOptions.AddMarketDeal.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.AddTransferDeal, text: SosContextMenuOptions.AddTransferDeal.text, cssClass: SosContextMenuOptions.AddTransferDeal.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.EditNomNote, text: SosContextMenuOptions.EditNomNote.text, cssClass: SosContextMenuOptions.EditNomNote.class, disabled: false });
        contextMenuItems.push({ menuOption: SosContextMenuOptions.KeepWhole, text: SosContextMenuOptions.KeepWhole.text, cssClass: SosContextMenuOptions.KeepWhole.class, disabled: false });
      }
    }

    return contextMenuItems;
  }
}
