import { Pipe, PipeTransform } from '@angular/core';
import { SosItem, SosNom, SosTransferItem } from '../models';
import { SosHelper } from '../sosHelper';

@Pipe({
  name: 'sosCellOverlayColorsCrude'
})
export class SosCellOverlayColorsPipe implements PipeTransform {
  private readonly changeableSupplyProps = ['activityNum', 'notes', 'pipeContractId', 'ptrContractId', 'ptrDeliveryMeterId', 'ptrPercent', 'sourceNotes', 'deliveryVol'];

  transform(originalClasses: string, propName: string = null, sosItem: SosItem | SosTransferItem = null, sosNom: SosNom, isPathEnd: boolean): string {
    let newClasses = '';
    const isTransferSumVol = propName === 'transferSumVol';
    // const isManualPtr = propName === 'ptrPercent' && sosItem.isManualPtr;
    const isTransferSource = propName && sosItem && (propName === 'supplyCounterparty' || propName === 'dealType' || propName === 'sourceMeter') && sosItem.supplyTicket?.includes("TFR");
    const isChangeableProp = this.changeableSupplyProps.includes(propName);
    const isChangedItem = isChangeableProp && sosItem.modifiedProps.includes(propName);
    const isTransferToTransferNom = sosNom && 'supplyNomId' in sosItem && sosItem.isTransferToTransfer;
    const isSupplyTicketEnteredFromSos = propName === 'supplyTicket' && sosItem.supplyTicket.startsWith('GAS') && sosItem.isEnteredFromSos;
    const isSourceTicketEnteredFromSos = propName === 'sourceTicket' && sosItem.isEnteredFromSos;
    const isEnteredFromSos = isSupplyTicketEnteredFromSos || isSourceTicketEnteredFromSos;
    // const isNegativeUnscheduledVol = propName === 'unscheduledVolume' && 'unscheduledVolume' in sosItem && sosItem.unscheduledVolume < 0;
    const isHidden = 'supplyNomId' in sosItem && sosItem.isHidden;
    const isEndDeliveryVol = propName === 'deliveryVol' && isPathEnd;
    const isSupplyClone = 'supplyNomId' in sosItem && sosItem.isSupplyClone;

    if (isTransferSumVol)
      newClasses = 'transferVolOverlay transferSumVol';
    else if (isTransferToTransferNom || isEndDeliveryVol)
      newClasses = 'transferVolOverlay';
    else if (sosNom?.isModified)
      newClasses = 'changedOverlay';
    else if (isChangedItem)
      newClasses = 'changedOverlay';
    // else if (isManualPtr)
    //   newClasses = 'manualPtrOverlay';
    else if (isTransferSource)
      newClasses = 'transferSourceOverlay';
    else if (isEnteredFromSos)
      newClasses = 'enteredFromSosOverlay t-text-color-whiteAndBlack';
    // else if (isNegativeUnscheduledVol)
    //   newClasses = 'negativeUnscheduledVolOverlay';
    else if (isHidden)
      newClasses = 'hiddenOverlay';
    else if (SosHelper.isMissingRequiredInfo(sosItem))
      newClasses = 'missingRequiredOverlay';
    else if (isSupplyClone)
      newClasses = 'supplyCloneOverlay';

    return originalClasses + ' ' + newClasses;
  }
}
