import { Component, ViewEncapsulation, ChangeDetectionStrategy, OnInit, Input, Output, EventEmitter, HostBinding, OnChanges, SimpleChanges } from '@angular/core';
import { DisplayInfo } from '../sos-settings/sos-settings.service';
import { SosItem, SosNom, SosTransferItem } from '../models';
import { ControlContainer, FormGroupDirective } from '@angular/forms';
import { ContextMenuSelectEvent, KENDO_CONTEXTMENU } from '@progress/kendo-angular-menu';
import { FAST_PAGE_COMMON } from '../../app.config';
import { KFormatNumPipe } from '../../_shared/pipes/k-format-num.pipe';
import { SosContextItemsPipe } from '../pipes/sos-context-items.pipe';
import { SosCellOverlayColorsPipe } from '../pipes/sos-cell-overlay-colors.pipe';
import { NgClass } from '@angular/common';

@Component({
  selector: 'app-sos-crude-elem-text[frozen][propName][sosItem][display][frozenColCount][activeElement][itemIdx][fontSizeStr][isPathEnd]',
  templateUrl: './sos-elem-text.html',
  styleUrls: ['./sos-elem-text.scss'],
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
  viewProviders: [{ provide: ControlContainer, useExisting: FormGroupDirective }],
  imports: [FAST_PAGE_COMMON, KENDO_CONTEXTMENU, KFormatNumPipe, SosContextItemsPipe, SosCellOverlayColorsPipe, NgClass]
})
export class SosElemTextComponent implements OnInit, OnChanges {
  @HostBinding('style.display') hostDisplay: string = 'flex';
  @HostBinding('style.order') componentOrder: number = 0;
  @Input() frozen: boolean;
  @Input() propName: keyof SosItem | keyof SosTransferItem | keyof SosNom;
  @Input() sosItem: SosItem | SosTransferItem;
  @Input() display: DisplayInfo;
  @Input() frozenColCount: number;
  @Input() activeElement: Element;
  @Input() itemIdx: number;
  @Input() fontSizeStr: string;
  @Input() isPathEnd: boolean;
  @Input() isLoading: boolean = false;
  @Input() hasContextMenu: boolean = true;

  @Input() numFormat: string;

  @Output() contextSelect = new EventEmitter<ContextMenuSelectEvent>();
  @Output() linkClicked = new EventEmitter();

  isLink = false;
  sosNom: SosNom = null;
  isTransferItem = false;
  isHidden = false;
  isNomVolume = false;
  isSupplyTransfer = false;
  sosItemVal: string;

  ngOnInit(): void {
    const isTicketProp = this.propName.toLowerCase().includes('ticket');
    const isTransferSumVolWithValue = this.propName === 'transferSumVol' && 'transferSumVol' in this.sosItem && this.sosItem.transferSumVol !== null;
    this.isLink = isTicketProp || isTransferSumVolWithValue;
    this.sosItemVal = this.sosItem ? this.sosItem[this.propName as keyof (SosItem | SosTransferItem)] as string : null;
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes.display)
      this.componentOrder = this.display?.order ?? 0;

    this.sosItemVal = this.sosItem ? this.sosItem[this.propName as keyof (SosItem | SosTransferItem)] as string : null;
    this.isSupplyTransfer = this.sosItem && 'supplyNomId' in this.sosItem && this.sosItem.transferDealId !== null;
    this.isTransferItem = this.sosItem && 'pathName' in this.sosItem ? true : false;
    this.isHidden = this.sosItem && 'isHidden' in this.sosItem ? this.sosItem.isHidden : false;
    this.isNomVolume = this.sosNom !== null;
  }

  clickInternal(event: MouseEvent): void {
    this.linkClicked.emit(event);
  }
}
