import { Routes } from '@angular/router';
import { NotFoundComponent } from './_shared/not-found.component';
import { RedirectGuard } from './_shared/redirect.guard';
import { RedirectComponent } from './_shared/redirect.component';
import { DefaultRouteRedirectComponent } from './_shared/default-route-redirect.component';
import { AppComponent } from './_shared/app.component';
import { TestComponent } from './_test/test.component';
import { inject } from '@angular/core';
import { AuthService } from './_shared/services/auth.service';
import { filter, map, take } from 'rxjs/operators';
// import app-specific components here:
import { PathingComponent as PathingGasComponent } from './sos-gas/pathing/pathing.component';
import { PathingComponent as PathingCrudeComponent } from './sos-crude/pathing/pathing.component';
import { PipeContractComponent } from './pipe-contract/pipe-contract.component';
import { PipeRateScheduleComponent } from './pipe-rate-schedule/pipe-rate-schedule.component';
import { SosComponent as SosGasComponent } from './sos-gas/sos.component';
import { SosTransfersComponent as SosGasTransfersComponent } from './sos-gas/sos-transfers/sos-transfers.component';
import { SosComponent as SosCrudeComponent } from './sos-crude/sos.component';
import { SosTransfersComponent as SosCrudeTransfersComponent } from './sos-crude/sos-transfers/sos-transfers.component';

export const defaultRoute = 'SOS';

//This guard waits for the auth check to complete before making redirect decisions,
export const oauthAuthGuard = () => {
  const authService = inject(AuthService);

  if (authService.authCheckComplete$.getValue() && authService.isLoggedIn())
    return true;

  if (authService.authCheckComplete$.getValue() && !authService.isLoggedIn()) {
    authService.login();
    return false;
  }

  return authService.authCheckComplete$.pipe(
    filter(complete => complete), // Wait until auth check is complete
    take(1), // Only take the first emission after completion
    map(() => {
      if (authService.isLoggedIn())
        return true;
      else {
        authService.login();
        return false; // Prevent Angular routing while redirecting
      }
    })
  );
};

/*
  do not add a path directly to AppComponent
  main.ts bootstraps to AppComponent which has a router-outlet that may then load a duplicate AppComponent
*/
export const routes: Routes = [
  { path: 'externalRedirect', canActivate: [RedirectGuard], component: RedirectComponent, data: { externalUrl: '' } },
  // add app-specific routes here:
  { path: 'Pathing', component: PathingGasComponent, canActivate: [oauthAuthGuard] },
  { path: 'PathingCrude', component: PathingCrudeComponent, canActivate: [oauthAuthGuard] },
  { path: 'PipeContract', component: PipeContractComponent, canActivate: [oauthAuthGuard] },
  { path: 'PipeRateSchedule', component: PipeRateScheduleComponent, canActivate: [oauthAuthGuard] },
  { path: 'SOS', component: SosGasComponent, canActivate: [oauthAuthGuard] },
  { path: 'SOSTransfers', component: SosGasTransfersComponent, canActivate: [oauthAuthGuard] },
  { path: 'SOSCrude', component: SosCrudeComponent, canActivate: [oauthAuthGuard] },
  { path: 'SOSCrudeTransfers', component: SosCrudeTransfersComponent, canActivate: [oauthAuthGuard] },
  // end app-specific routes
  { path: 'Root', component: AppComponent, canActivate: [oauthAuthGuard] },
  { path: '', component: DefaultRouteRedirectComponent, pathMatch: 'full' },
  { path: 'Test/:tag', component: TestComponent }, //view Test page to display a component based on the tag
  { path: 'Test', component: TestComponent }, //view blank Test page
  { path: '**', component: NotFoundComponent, data: { title: 'Not Found' } }
];
