import { ChangeDetectionStrategy, Component, inject, OnInit, signal, ViewEncapsulation } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { KENDO_DIALOG } from '@progress/kendo-angular-dialog';

// This primarily helps with testing child components in isolation
// The test component URL is https://127.0.0.1:{port}/#/Test/{tag} where {tag} is one of the strings below, without quotes
// To hide the theme picker add the topless query parameter with a value of 1: https://127.0.0.1:{port}/#/Test/{tag}?topless=1
// The tag determines which child component is rendered

@Component({
    template: `
    <div id="container" class="t-bg-color2 col-g hideOverflow">
      @if(!tag()) { <h1 class="t-text-color1">place a test component tag with a tag conditional here: E.G. <div>{{exampleComponentHtmlString}}</div></h1> }
    </div>
  `,
    styles: `
    app-test { background-color: gray; height: 100%; }
    app-test #container > * { display: flex; flex-grow: 1; flex-direction: column; height: 100%; }
  `,
    selector: 'app-test',
    encapsulation: ViewEncapsulation.None,
    changeDetection: ChangeDetectionStrategy.OnPush,
    imports: [KENDO_DIALOG]
})
export class TestComponent implements OnInit {
  exampleComponentHtmlString = `
    @if (tag() === 'approval-docs') { <app-approval-docs [creditLimitId]="361"]></app-approval-docs> }
  `;
  route = inject(ActivatedRoute);
  tag = signal<string>(null);

  ngOnInit(): void {
    this.route.params.subscribe(params => {
      this.tag.set(params['tag']);
    });
  }
}
