import { Component, HostBinding, input } from '@angular/core';
import { FastOverlayComponent } from "../fast-overlay/fast-overlay-component";

@Component({
  selector: 'fast-spinner',
  imports: [FastOverlayComponent],
  template: `
@if(hasOverlay()) { <fast-overlay [isContained]="isContained()" [opacityLevel]="'light'" /> }
<svg id="spinner" xmlns="http://www.w3.org/2000/svg" aria-live="polite" aria-busy="true" viewBox="0 0 26 26" role="img" aria-label="Loading"
  [style.width.px]="size()" [style.height.px]="size()"
>
  <circle id="background" cx="13" cy="13" r="13" fill="gray" stroke="none"></circle>
  <circle id="outer-spinner" cx="13" cy="13" r="12" opacity="1" fill="none" stroke-width="2" stroke-dasharray="19 19"></circle>
  <circle id="inner-spinner" cx="13" cy="13" r="5" opacity="1" fill="none" stroke-width="1" stroke-dasharray="8 8"></circle>
</svg>
  `,
  styles: `
@use '../../../../styles/variables.scss';

:host { //some host styles are set in the component class
  z-index: 10;
}

#spinner {
  position: absolute;
  top: 50%;
  left: 50%;
}

@keyframes rotateForward {
  from { transform: rotate(0deg); }
  to { transform: rotate(360deg); }
}

@keyframes rotateBackward {
  from { transform: rotate(0deg); }
  to { transform: rotate(-360deg); }
}

#inner-spinner {
  transform-origin: 50% 50%;
  animation: rotateBackward 1s linear infinite;
  stroke: variables.$highlight-color;
}

#outer-spinner {
  transform-origin: 50% 50%;
  animation: rotateForward 1s linear infinite;
  stroke: variables.$highlight-color;
}
`
})
export class FastSpinnerComponent {
  size = input(65); // Size in pixels
  isContained = input(false); // Whether the spinner is contained within a parent element
  hasOverlay = input(true); // Whether the spinner has a shaded overlay that prevents clicks

  @HostBinding('style') get hostStyles() {
    return {
      position: this.isContained() ? 'absolute' : 'fixed',
      width: this.hasOverlay() ? '100%' : 'auto',
      height: this.hasOverlay() ? '100%' : 'auto',
      top: this.hasOverlay() ? '0%' : '50%',
      left: this.hasOverlay() ? '0%' : '50%',
    };
  }
}
